/*
 * Decompiled with CFR 0.152.
 */
package music;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import music.Main;
import music.PaintSurface;
import music.commonUtils;
import music.getBackgroundNoise;
import music.songConverter;
import org.jdesktop.layout.GroupLayout;

public class settings
extends JLabel {
    private static final long serialVersionUID = 500L;
    private static final int smaller = 100;
    private Frame parentFrame = null;
    private int frameWidth = 0;
    private int frameHeight = 0;
    private static String fileName = "settings.txt";
    private static boolean hasChanged = false;
    public static double backgroundNoise = -1.0;
    public static int defaultInstrument = 2;
    public static int screenHeight = 588;
    public static int screenWidth = 800;
    public static int PPB = 60;
    public static int firstNoteLength = 1000;
    public static String maxRestLength = "10";
    public static String minRestLength = "0";
    public static String maxNoteLength = "10";
    public static String minNoteLength = "0";
    public static int maxNumOctavesDuringConversion = 3;
    public static int maxInterval = 24;
    public static int difficulty = 0;
    public static boolean music = true;

    public settings() {
        settings.readSettings();
    }

    public void setFrame(JFrame e) {
        this.parentFrame = e;
        this.frameWidth = e.getWidth() - 100;
        this.frameHeight = e.getHeight() - 100;
    }

    private static void readSettings() {
        String text = "";
        try {
            BufferedReader i = new BufferedReader(new FileReader(fileName));
            text = i.readLine();
            i.close();
            StringTokenizer st = new StringTokenizer(text, " ");
            backgroundNoise = Double.parseDouble(st.nextToken());
            defaultInstrument = Integer.parseInt(st.nextToken());
            screenHeight = Integer.parseInt(st.nextToken());
            screenWidth = Integer.parseInt(st.nextToken());
            PPB = Integer.parseInt(st.nextToken());
            firstNoteLength = Integer.parseInt(st.nextToken());
            maxRestLength = st.nextToken();
            minRestLength = st.nextToken();
            maxNoteLength = st.nextToken();
            minNoteLength = st.nextToken();
            maxNumOctavesDuringConversion = Integer.parseInt(st.nextToken());
            maxInterval = Integer.parseInt(st.nextToken());
            difficulty = Integer.parseInt(st.nextToken());
            music = Boolean.parseBoolean(st.nextToken());
        }
        catch (Exception e) {
            settings.write();
        }
    }

    private static void write() {
        settings.write(backgroundNoise);
    }

    public static void write(boolean bkMusic) {
        settings.writeSettings(backgroundNoise, defaultInstrument, screenHeight, screenWidth, PPB, firstNoteLength, maxRestLength, minRestLength, maxNoteLength, minNoteLength, maxNumOctavesDuringConversion, maxInterval, difficulty, bkMusic);
    }

    public static void write(double noise) {
        settings.writeSettings(noise, defaultInstrument, screenHeight, screenWidth, PPB, firstNoteLength, maxRestLength, minRestLength, maxNoteLength, minNoteLength, maxNumOctavesDuringConversion, maxInterval, difficulty, music);
    }

    private static void writeSettings(double bN, int iM, int sH, int sW, int pB, int fN, String maR, String miR, String maN, String miN, int mN, int mI, int d, boolean b) {
        block2: {
            String write = Double.toString(bN).concat(" ");
            write = write.concat(Integer.toString(iM)).concat(" ").concat(Integer.toString(sH)).concat(" ").concat(Integer.toString(sW)).concat(" ").concat(Integer.toString(pB)).concat(" ").concat(Integer.toString(fN)).concat(" ").concat(maR).concat(" ").concat(miR).concat(" ").concat(maN).concat(" ").concat(miN).concat(" ").concat(Integer.toString(mN).concat(" ").concat(Integer.toString(mI)).concat(" ").concat(Integer.toString(d).concat(" "))).concat(Boolean.toString(b).concat(" "));
            try {
                BufferedWriter o = new BufferedWriter(new FileWriter(fileName));
                o.write(write);
                o.close();
            }
            catch (IOException e) {
                if (!Main.debugErrors) break block2;
                System.out.println(e);
            }
        }
    }

    public void changeSettings() {
        hasChanged = false;
        PaintSurface picPanel = new PaintSurface("b2.png");
        final JFrame j = new JFrame("Settings");
        j.setMaximumSize(new Dimension(this.frameWidth, this.frameHeight));
        j.setDefaultCloseOperation(3);
        j.setIconImage(Main.imgIcon);
        j.setMinimumSize(new Dimension(600, 250));
        j.setResizable(false);
        final getBackgroundNoise backgroundNoiseLabel = new getBackgroundNoise(j);
        String noise = Double.toString(backgroundNoise);
        backgroundNoiseLabel.setText("Background Noise = " + noise.substring(0, noise.indexOf(46) + 2));
        JLabel defaultInstrumentLabel = new JLabel("Default Instrument");
        final JComboBox<String> defaultInstrumentField = new JComboBox<String>();
        defaultInstrumentField.setModel(new DefaultComboBoxModel<String>(Main.instList));
        defaultInstrumentField.setSelectedIndex(defaultInstrument);
        JLabel screenHeightLabel = new JLabel("Screen Height");
        final JTextField screenHeightField = new JTextField(Integer.toString(screenHeight));
        JLabel screenWidthLabel = new JLabel("Screen Width");
        final JTextField screenWidthField = new JTextField(Integer.toString(screenWidth));
        JLabel pixelsPerBeatLabel = new JLabel("Pixels Per Beat");
        final JTextField pixelsPerBeatField = new JTextField(Integer.toString(PPB));
        JLabel pitchReferenceLengthLabel = new JLabel("Pitch Reference Length");
        final JTextField pitchReferenceLengthField = new JTextField(Integer.toString(firstNoteLength));
        JLabel maxRestLengthLabel = new JLabel("Max Rest Length");
        final JTextField maxRestLengthField = new JTextField(maxRestLength);
        JLabel minRestLengthLabel = new JLabel("Min Rest Length");
        final JTextField minRestLengthField = new JTextField(minRestLength);
        JLabel maxNoteLengthLabel = new JLabel("Max Note Length");
        final JTextField maxNoteLengthField = new JTextField(maxNoteLength);
        JLabel minNoteLengthLabel = new JLabel("Min Note Length");
        final JTextField minNoteLengthField = new JTextField(minNoteLength);
        final JButton saveButton = new JButton("Save Settings");
        JButton closeButton = new JButton("Close");
        JButton helpButton = new JButton("Help");
        JLabel heading1 = new JLabel("<html><font size=4><b>Game Settings</b>");
        JLabel heading2 = new JLabel("<html><font size=4><b>Music Conversion Settings");
        JLabel octavesLabel = new JLabel("Max Range (Octaves)");
        final JSpinner maxRangeSpinner = new JSpinner();
        maxRangeSpinner.setValue(maxNumOctavesDuringConversion);
        final JButton backgroundNoiseButton = new JButton("Sample Noise");
        JLabel maxIntervalLabel = new JLabel("Max Interval");
        final JSpinner maxIntervalSpinner = new JSpinner();
        maxIntervalSpinner.setValue(maxInterval);
        JLabel difficultyLabel = new JLabel("Song Difficulty");
        JRadioButton easyRadioButton = new JRadioButton("Easy");
        final JRadioButton intermediateRadioButton = new JRadioButton("Intermediate");
        final JRadioButton hardRadioButton = new JRadioButton("Hard");
        JSeparator separator = new JSeparator();
        ButtonGroup levelButtons = new ButtonGroup();
        levelButtons.add(easyRadioButton);
        levelButtons.add(intermediateRadioButton);
        levelButtons.add(hardRadioButton);
        if (difficulty == 1) {
            intermediateRadioButton.setSelected(true);
        } else if (difficulty == 2) {
            hardRadioButton.setSelected(true);
        } else {
            easyRadioButton.setSelected(true);
        }
        ItemListener iL = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                saveButton.setText("Save Settings");
                hasChanged = true;
            }
        };
        CaretListener cL = new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                saveButton.setText("Save Settings");
                hasChanged = true;
            }
        };
        ChangeListener CL = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                saveButton.setText("Save Settings");
                hasChanged = true;
            }
        };
        MouseListener mL = new MouseListener(){

            public void mouseClicked(MouseEvent evt) {
            }

            public void mouseEntered(MouseEvent e) {
                backgroundNoiseLabel.setFont(backgroundNoiseLabel.getFont().deriveFont(2));
            }

            public void mouseExited(MouseEvent e) {
                backgroundNoiseLabel.setFont(backgroundNoiseLabel.getFont().deriveFont(0));
            }

            public void mousePressed(MouseEvent e) {
                backgroundNoiseButton.setText("<html><font color='#000000'>Please Wait...</font>");
                backgroundNoiseButton.paintImmediately(backgroundNoiseLabel.getBounds());
            }

            public void mouseReleased(MouseEvent mR) {
                if (!backgroundNoiseButton.getText().equals("<html><font color='#000000'>Complete!</font>")) {
                    boolean micWorks;
                    block5: {
                        Main.song.off();
                        micWorks = backgroundNoiseLabel.calc();
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException Ie) {
                            if (!Main.debugErrors) break block5;
                            System.out.println(Ie);
                        }
                    }
                    String noise = Double.toString(backgroundNoise);
                    backgroundNoiseLabel.setText("Background Noise = " + noise.substring(0, noise.indexOf(46) + 2));
                    Main.song.playRandomSong();
                    if (micWorks) {
                        backgroundNoiseButton.setText("<html><font color='#000000'>Complete!</font>");
                    } else {
                        backgroundNoiseLabel.setText("<html><font color='#000000'>Microphone Not Found!</font>");
                        JOptionPane.showMessageDialog(j, "<html>Your microphone could not be found.  If you have one,<br> make sure it's working and restart the program.  If you don't<br> have a microphone, this game can't hear you play.  You may <br>still run it to display music.", "Error", 2);
                    }
                }
            }
        };
        screenHeightField.addCaretListener(cL);
        screenWidthField.addCaretListener(cL);
        pixelsPerBeatField.addCaretListener(cL);
        pitchReferenceLengthField.addCaretListener(cL);
        maxRestLengthField.addCaretListener(cL);
        minRestLengthField.addCaretListener(cL);
        maxNoteLengthField.addCaretListener(cL);
        minNoteLengthField.addCaretListener(cL);
        defaultInstrumentField.addItemListener(iL);
        maxRangeSpinner.addChangeListener(CL);
        backgroundNoiseButton.addChangeListener(CL);
        maxIntervalSpinner.addChangeListener(CL);
        easyRadioButton.addChangeListener(CL);
        intermediateRadioButton.addChangeListener(CL);
        hardRadioButton.addChangeListener(CL);
        GroupLayout jPanel1Layout = new GroupLayout(picPanel);
        picPanel.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(0, 273, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(0, 23, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(j.getContentPane());
        j.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(separator, -1, 560, Short.MAX_VALUE).add(layout.createSequentialGroup().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(layout.createParallelGroup(1).add(heading1, -1, 250, Short.MAX_VALUE).add(backgroundNoiseLabel, -2, 141, -2)).add(21, 21, 21)).add(layout.createSequentialGroup().add(pixelsPerBeatLabel).addPreferredGap(0).add(pixelsPerBeatField, -2, 30, -2).addPreferredGap(1).add(pitchReferenceLengthLabel, -2, 118, -2).addPreferredGap(0).add(pitchReferenceLengthField, -1, 34, Short.MAX_VALUE)).add(layout.createSequentialGroup().add(defaultInstrumentLabel, -2, 100, -2).addPreferredGap(0).add(defaultInstrumentField, 0, 167, Short.MAX_VALUE)).add(layout.createSequentialGroup().add(screenHeightLabel, -2, 70, -2).addPreferredGap(0).add(screenHeightField, -2, 50, -2).add(18, 18, 18).add(layout.createParallelGroup(1).add(backgroundNoiseButton, -1, 129, Short.MAX_VALUE).add(layout.createSequentialGroup().add(screenWidthLabel, -2, 75, -2).addPreferredGap(0).add(screenWidthField, -1, 50, Short.MAX_VALUE))))).add(20, 20, 20).add(layout.createParallelGroup(2).add(heading2, -1, 269, Short.MAX_VALUE).add(1, layout.createSequentialGroup().add(layout.createParallelGroup(1, false).add(layout.createSequentialGroup().add(octavesLabel).addPreferredGap(0).add(maxRangeSpinner, 0, 0, Short.MAX_VALUE)).add(layout.createSequentialGroup().add(layout.createParallelGroup(1, false).add(maxRestLengthLabel, -1, -1, Short.MAX_VALUE).add(maxNoteLengthLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add(layout.createParallelGroup(1).add(maxNoteLengthField, -2, 50, -2).add(maxRestLengthField, -2, 50, -2)))).addPreferredGap(1).add(layout.createParallelGroup(1).add(maxIntervalLabel, -1, 80, Short.MAX_VALUE).add(minNoteLengthLabel, -1, 80, Short.MAX_VALUE).add(minRestLengthLabel, -1, 80, Short.MAX_VALUE)).addPreferredGap(0).add(layout.createParallelGroup(1, false).add(maxIntervalSpinner).add(minNoteLengthField).add(minRestLengthField)).add(5, 5, 5)).add(1, layout.createSequentialGroup().add(difficultyLabel, -2, 78, -2).addPreferredGap(0).add(easyRadioButton).addPreferredGap(0).add(intermediateRadioButton).add(6, 6, 6).add(hardRadioButton)))).add(2, layout.createSequentialGroup().add(picPanel, -1, -1, Short.MAX_VALUE).add(18, 18, 18).add(helpButton, -2, 77, -2).addPreferredGap(0).add(saveButton).addPreferredGap(0).add(closeButton, -2, 81, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(3).add(heading1, -2, 32, -2).add(heading2, -2, 34, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(backgroundNoiseLabel, -2, 20, -2).add(maxNoteLengthLabel, -2, 20, -2).add(maxNoteLengthField, -2, -1, -2).add(minNoteLengthLabel, -2, 20, -2).add(minNoteLengthField, -2, -1, -2).add(backgroundNoiseButton, -2, 20, -2)).add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(11, 11, 11).add(layout.createParallelGroup(3).add(maxRestLengthLabel, -2, 20, -2).add(maxRestLengthField, -2, -1, -2).add(minRestLengthLabel, -2, 20, -2).add(minRestLengthField, -2, -1, -2))).add(layout.createSequentialGroup().addPreferredGap(1).add(layout.createParallelGroup(3).add(screenHeightLabel, -2, 20, -2).add(screenHeightField, -2, -1, -2).add(screenWidthLabel, -2, 20, -2).add(screenWidthField, -2, -1, -2)).addPreferredGap(1).add(layout.createParallelGroup(3).add(pixelsPerBeatLabel, -2, 20, -2).add(pixelsPerBeatField, -2, -1, -2).add(pitchReferenceLengthField, -2, -1, -2).add(octavesLabel).add(maxRangeSpinner, -2, -1, -2).add(maxIntervalLabel).add(maxIntervalSpinner, -2, -1, -2).add(pitchReferenceLengthLabel, -2, 20, -2)))).addPreferredGap(1).add(layout.createParallelGroup(3).add(defaultInstrumentLabel, -2, 20, -2).add(defaultInstrumentField, -2, -1, -2).add(difficultyLabel).add(hardRadioButton).add(easyRadioButton).add(intermediateRadioButton)).addPreferredGap(1).add(separator, -2, 10, -2).addPreferredGap(0).add(layout.createParallelGroup(1).add(layout.createParallelGroup(3).add(closeButton, -2, 20, -2).add(saveButton, -2, 21, -2).add(helpButton, -2, 21, -2)).add(picPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (hasChanged) {
                    int x = JOptionPane.showConfirmDialog(j, "Settings have changed.  Do you want to save them?", "Keep Changes?", 1, 1, Main.icoIcon);
                    if (x == 0) {
                        saveButton.doClick();
                    } else if (x == 2) {
                        return;
                    }
                }
                j.setVisible(false);
                j.dispose();
            }
        });
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                defaultInstrument = defaultInstrumentField.getSelectedIndex();
                screenHeight = Integer.parseInt(screenHeightField.getText());
                screenWidth = Integer.parseInt(screenWidthField.getText());
                PPB = Integer.parseInt(pixelsPerBeatField.getText());
                firstNoteLength = Integer.parseInt(pitchReferenceLengthField.getText());
                maxRestLength = maxRestLengthField.getText();
                minRestLength = minRestLengthField.getText();
                maxNoteLength = maxNoteLengthField.getText();
                minNoteLength = minNoteLengthField.getText();
                maxNumOctavesDuringConversion = Integer.parseInt(maxRangeSpinner.getValue().toString());
                maxInterval = Integer.parseInt(maxIntervalSpinner.getValue().toString());
                difficulty = intermediateRadioButton.isSelected() ? 1 : (hardRadioButton.isSelected() ? 2 : 0);
                if (!songConverter.initializeVars()) {
                    JOptionPane.showMessageDialog(j, "<html>Please enter fractions or whole numbers in the fields Max<br>Rest Length, Min Rest Length, Max Note Length, and Min Note<br>Length.  Example inputs include 2 and 2/1.", "Error Reading Input", 1);
                } else {
                    saveButton.setText("Saved!");
                    settings.write();
                    hasChanged = false;
                }
            }
        });
        helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(j, "<html>" + commonUtils.dialogFormat("This page allows you to change some of the settings.  Of these, <b>background noise</b>, the level of ambient noise, is the most important.  This allows the game to distinguish a note from a rest.  Press 'Sample Noise' to sample the current background noise level.  You should do this every time you play the game in a new environment.  Changing the <b>default instrument</b> lets you choose the instrument automatically selected when a song is played (of course, you can still choose a different one). <b>Screen height</b> stores the default height of the window on startup, and <b>screen width</b> stores its width.  <b>Pixels per beat</b> is how many pixels wide each beat is, with 60 as the default.  This can be decreased if performance becomes an issue.  <b>Pitch reference length</b> represents the length of the first note tone off which singers can base their pitch, in milliseconds.  The <b>min/max rest and note lengths</b> are the number of beats necessary for a note or rest to be translated in the song converter.  Any note or rest longer than the max lengths will be cutoff, and any note or rest shofter than the min length will be ignored.", 80), "Settings Help", 1);
            }
        });
        backgroundNoiseButton.addMouseListener(mL);
        j.pack();
        j.setLocationRelativeTo(this.parentFrame);
        j.setVisible(true);
    }
}

